monteCarloTrials = function(Mi, n_runs, tf, disturbanceSeq){
  matrixLength = dim(Mi)[1]
  
  colonizationExtent = array(NA, dim = c(tf,n_runs))
  for(i_run in 1:n_runs){
    # Generate matrix time series
    M = array(NA, dim = c(matrixLength,matrixLength,tf))
    M[,,1] = Mi
    
    # Choose disturbance magnitude (high-sd = calm, low-sd = extreme)
    disturbanceParameter = disturbanceSeq[i_run]
    set.seed(i_run)
    r = rlnorm(n = tf, meanlog = 1, sdlog = disturbanceParameter)
    disturbanceSize = (r/max(r))
    
    # Run simulations
    patchArea = rep(NA, times = tf)
    t = 1
    patchArea[t] = 0.1
    while(patchArea[t] > 0 & patchArea[t] < 1 & t < tf){
      M[,,t + 1] = monteCarlo(M = M[,,t], 
                              disturbanceSize = disturbanceSize[t], 
                              growthRate = 0.01)
      patchArea[t + 1] = sum(M[,,t + 1])/matrixLength^2
      t = t + 1
    }
    patchArea[t:tf] = patchArea[t]
    
    colonizationExtent[,i_run] = patchArea
  }
  return(colonizationExtent)
}